/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.api;

import filenet.vw.api.VWAttributeInfo;
import filenet.vw.api.VWException;
import filenet.vw.api.VWFetchType;
import filenet.vw.api.VWPersistentCollection;
import filenet.vw.api.VWQueue;
import filenet.vw.api.VWQueueQuery;
import filenet.vw.api.VWServerException;
import filenet.vw.api.VWSession;
import filenet.vw.api.VWWorkBasketColumnDefinition;
import filenet.vw.api.VWWorkBasketDefinition;
import filenet.vw.api.VWWorkBasketFilterDefinition;
import filenet.vw.api.VWWorkElement;
import filenet.vw.base.logging.Logger;
import filenet.vw.server.InternalVWWorkBasket;
import filenet.vw.server.VWQueueRecord;
import filenet.vw.server.VWWorkRecord;
import java.io.Serializable;
import java.util.Date;

public class VWWorkBasket
extends VWQueueQuery
implements Serializable {
    protected static final Logger logger = Logger.getLogger("filenet.vw.api.VWWorkBasket");
    protected static final String m_className = "VWWorkBasket";
    private static final long serialVersionUID = 7424L;
    private Column[] columns;
    private int nColumns = 0;
    private Filter[] filters;
    private int nFilters = 0;
    private VWWorkBasketDefinition wbDef;
    private String qName = null;
    private VWSession session;
    private String m_desc;

    public static String _get_FILE_DATE() {
        return "$Date: 2010-08-04 17:06:45 GMT $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author: David Wang;5D6193897;davidwang@us.ibm.com (dwang) $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision: /main/PUI_452_Int/PUI_460_Int/2 $";
    }

    private VWSession getSession() {
        if (this.session == null) {
            try {
                this.session = this.getSource().getServiceSession();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.session;
    }

    protected Filter getFilter(String filterName) throws VWException {
        if (this.nFilters == 0) {
            return null;
        }
        filterName = VWWorkBasket.GetName(filterName, this.getSession());
        for (int i = 0; i < this.nFilters; ++i) {
            if (!this.filters[i].getAuthoredName().equals(filterName)) continue;
            return this.filters[i];
        }
        return null;
    }

    public String getName() throws VWException {
        return VWWorkBasket.GetName(this.wbDef.getName(), this.session);
    }

    public String getAuthoredName() throws VWException {
        return VWWorkBasket.GetAuthoredName(this.wbDef.getName(), this.session);
    }

    public String getDescription() throws VWException {
        return this.wbDef.getDescription();
    }

    public String getQueueName() {
        if (this.qName == null && this.querySource != null) {
            this.qName = this.querySource.getAuthoredName();
        }
        return this.qName;
    }

    public int getId() {
        return this.workBasketId;
    }

    public int getRevision() throws VWException {
        return this.wbDef.getRevision();
    }

    public VWAttributeInfo getAttributeInfo() throws VWException {
        return this.wbDef.getAttributeInfo();
    }

    public VWQueue getQueue() {
        return (VWQueue)this.querySource;
    }

    public Column[] getColumns() {
        return this.columns;
    }

    public Filter[] getFilters() {
        return this.filters;
    }

    private boolean notNullnorNonNulLOperator(Filter f) throws VWException {
        int filterOp = f.getOperator();
        return filterOp != 9 && filterOp != 8;
    }

    private void validateFetchInBatchArgs(int query_flags, int buffer_size, String sort_column, String[] filter_names, Object[] substitution_vars, int fetch_type) throws VWException {
        if (buffer_size < 1) {
            throw new VWException("vw.api.VWQueuefetchBufferSizeInvalid", "Buffer size specified to fetch is not valid.");
        }
        if (!VWFetchType.isValid(fetch_type) || fetch_type == 4) {
            throw new VWException("vw.api.VWQueuefetchTypeInvalid", "Fetch type for VWQueue is not valid. {0}", this.fetchType);
        }
        if (sort_column != null) {
            boolean isValid = false;
            for (int i = 0; i < this.nColumns && !isValid; ++i) {
                if (!sort_column.equals(this.columns[i].getAuthoredName())) continue;
                isValid = true;
            }
            if (!isValid) {
                throw new VWException("vw.api.VWWorkBasketInvalidColumn", "Column name is not valid. {0}", sort_column);
            }
        }
        int nAskedFilters = filter_names == null ? 0 : filter_names.length;
        int nSubstitutionVars = substitution_vars == null ? 0 : substitution_vars.length;
        int nExpSubsVars = 0;
        if (nAskedFilters > 0) {
            for (int j = 0; j < nAskedFilters; ++j) {
                filter_names[j] = VWWorkBasket.GetAuthoredName(filter_names[j], this.getSession());
                boolean isValid = false;
                for (int i = 0; i < this.nFilters && !isValid; ++i) {
                    if (!filter_names[j].equals(this.filters[i].getAuthoredName())) continue;
                    if (this.notNullnorNonNulLOperator(this.filters[i])) {
                        if (nExpSubsVars == nSubstitutionVars) {
                            throw new VWException("vw.api.VWWorkBasket.fetch.FilterDoesNotHaveValue", "Filter [{0}] does not have a value specified.", filter_names[j]);
                        }
                        ++nExpSubsVars;
                    }
                    switch (this.filters[i].getType()) {
                        case 16: {
                            Object o;
                            if (!this.notNullnorNonNulLOperator(this.filters[i]) || (o = substitution_vars[nExpSubsVars - 1]) == null || o instanceof Date) break;
                            throw new VWException("vw.api.VWWorkBasket.fetch.SubVarIsNotDate", "The value for filter [{0}] is not of Date type.", filter_names[j]);
                        }
                    }
                    isValid = true;
                }
                if (isValid) continue;
                throw new VWException("vw.api.VWWorkBasket.fetch.InvalidFilterName", "Filter name is not valid. {0}", filter_names[j]);
            }
        }
    }

    public QueryResults fetchNextBatch(int query_flags, int buffer_size, String sort_column, String[] filter_names, Object[] substitution_vars, String lastWorkRecStr, int fetch_type) throws VWException {
        if (this.queryIsOver) {
            return null;
        }
        String m_method = "fetchNextBatch";
        this.validateFetchInBatchArgs(query_flags, buffer_size, sort_column, filter_names, substitution_vars, fetch_type);
        if (lastWorkRecStr != null && lastWorkRecStr.length() > 0) {
            this.lastRecord = VWWorkRecord.fromString(lastWorkRecStr, VWQueueRecord.class);
            if (this.lastRecord == null) {
                throw new VWException("vw.api.VWWorkBasket.invalidLastRecord", "The last record is invalid");
            }
        } else {
            this.lastRecord = null;
        }
        this.queryFetchType = fetch_type;
        this.queryFlags = this.mapQueryFlags(query_flags);
        this.bufferSize = buffer_size;
        this.sortColumn = sort_column;
        this.wbFilterNames = filter_names;
        this.substitutionVars = substitution_vars;
        StringBuffer buf = new StringBuffer();
        if (logger.isFinest()) {
            buf.append(this.toString()).append("\nfetchNextBatch: qf=").append(query_flags).append(",bs=").append(buffer_size).append(",sc=").append(sort_column).append(",fn=").append(Logger.asString(filter_names)).append(",sv=").append(Logger.asString(substitution_vars)).append(",lr=").append(lastWorkRecStr).append(",ft=").append(fetch_type);
        }
        try {
            this.dofetch();
            if (this.fetchCount == 0) {
                this.queryIsOver = true;
                return null;
            }
            this.returnCount = this.fetchCount;
            lastWorkRecStr = this.lastRecord == null ? null : this.lastRecord.getStringVersion();
            QueryResults res = new QueryResults(buf.toString(), (VWWorkElement[])this.fetchedObjects, lastWorkRecStr);
            if (logger.isFinest()) {
                logger.finest(m_className, "fetchNextBatch", res.toString());
            }
            return res;
        }
        catch (VWServerException ex) {
            if (ex.getTuple() == -714276809L) {
                if (logger.isFinest()) {
                    logger.finest(m_className, "fetchNextBatch", "Query is Over?");
                }
                this.queryIsOver = true;
                return null;
            }
            throw ex;
        }
    }

    public int fetchBatchCount(int query_flags, String sort_column, String[] filter_names, Object[] substitution_vars, int fetch_type) throws VWException {
        String m_method = "fetchBatchCount";
        int res = 0;
        this.validateFetchInBatchArgs(query_flags, 50, sort_column, filter_names, substitution_vars, fetch_type);
        StringBuffer buf = new StringBuffer();
        if (logger.isFinest()) {
            buf.append(this.toString()).append("\nfetchBatchCount: qf=").append(query_flags).append(",sc=").append(sort_column).append(",fn=").append(Logger.asString(filter_names)).append(",sv=").append(Logger.asString(substitution_vars)).append(",ft=").append(fetch_type);
        }
        try {
            res = this.fetchCount(this.indexName, this.minValues, this.maxValues, query_flags, this.filterSQL, substitution_vars, this.queryType, fetch_type, sort_column, filter_names, this.workBasketId);
            if (logger.isFinest()) {
                logger.finest(m_className, "fetchBatchCount", Integer.valueOf(res).toString());
            }
            return res;
        }
        catch (VWServerException ex) {
            if (ex.getTuple() == -714276809L) {
                if (logger.isFinest()) {
                    logger.finest(m_className, "fetchBatchCount", "Query count failed");
                }
                return 0;
            }
            throw ex;
        }
    }

    public String toString() {
        if (logger.isFinest()) {
            if (this.m_desc == null) {
                StringBuffer buf = new StringBuffer();
                buf.append("VWWorkBasket[");
                try {
                    buf.append(this.getName()).append("], q=").append(this.qName).append(", id=").append(this.workBasketId).append(", idx=").append(this.indexName).append(", fSQL=").append(this.filterSQL).append(", qft=").append(this.queryFetchType).append(",\n\tColumns=").append(Logger.asString(this.columns)).append(",\n\tFilters=").append(Logger.asString(this.filters));
                }
                catch (Exception e) {
                    buf.append("Got exception!");
                }
                this.m_desc = buf.toString();
            }
            return this.m_desc;
        }
        return super.toString();
    }

    protected VWWorkBasket(VWPersistentCollection querySource, String index_Name, Object[] min_Values, Object[] max_Values, int query_Flags, String pre_Filter_SQL, Object[] substitution_Vars, int query_Type) throws VWException {
        super(querySource, index_Name, min_Values, max_Values, query_Flags, pre_Filter_SQL, substitution_Vars, query_Type);
        this.getSession();
    }

    protected VWWorkBasket(VWPersistentCollection querySource, String index_Name, Object[] min_Values, Object[] max_Values, int query_Flags, String pre_Filter_SQL, Object[] substitution_Vars, int query_Type, int buffer_Size, int fetch_Type) throws VWException {
        super(querySource, index_Name, min_Values, max_Values, query_Flags, pre_Filter_SQL, substitution_Vars, query_Type, buffer_Size, fetch_Type);
        this.getSession();
    }

    protected static VWWorkBasket getVWWorkBasket(InternalVWWorkBasket _workBasket, VWQueue queue) throws VWException {
        VWWorkBasketDefinition wbDef = _workBasket.wbDef;
        wbDef.setSession(queue.getSession());
        VWWorkBasket res = new VWWorkBasket(queue, wbDef.getIndexName(), null, null, 1, wbDef.getQueryFilterString(), null, 2, 50, 5);
        res.workBasketId = wbDef.getObjId();
        res.wbDef = wbDef;
        res.setColumns(wbDef.getWorkBasketColumnDefinitions());
        res.setFilters(wbDef.getWorkBasketFilterDefinitions());
        return res;
    }

    private void setColumns(VWWorkBasketColumnDefinition[] columns) {
        this.nColumns = columns == null ? 0 : columns.length;
        this.columns = new Column[this.nColumns];
        for (int i = 0; i < this.nColumns; ++i) {
            this.columns[i] = new Column(columns[i], this.getSession());
        }
    }

    private void setFilters(VWWorkBasketFilterDefinition[] filters) {
        this.nFilters = filters == null ? 0 : filters.length;
        this.filters = new Filter[this.nFilters];
        for (int i = 0; i < this.nFilters; ++i) {
            this.filters[i] = new Filter(filters[i], this.getSession());
        }
    }

    protected static String GetName(String name, VWSession session) throws VWException {
        if (session != null) {
            try {
                return session.translate(name);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return name;
    }

    protected static String GetAuthoredName(String name, VWSession session) throws VWException {
        if (session != null) {
            try {
                return session.translateToAuthored(name);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return name;
    }

    public boolean isShowWorkForAllUsers() {
        if (this.wbDef == null) {
            return false;
        }
        return this.wbDef.isShowWorkForAllUsers();
    }

    public static class QueryResults
    implements Serializable {
        private static final long serialVersionUID = 7424L;
        private VWWorkElement[] wobs;
        private String lastRecord;
        private String queryChars = null;
        private String m_desc = null;

        protected QueryResults(String queryChars, VWWorkElement[] wobs, String lastRecord) {
            this.wobs = wobs;
            this.lastRecord = lastRecord;
            this.queryChars = queryChars;
        }

        public String getLastRecord() {
            return this.lastRecord;
        }

        public Object[] getWorkObjects() {
            return this.wobs;
        }

        public String toString() {
            if (logger.isFinest()) {
                if (this.m_desc == null) {
                    try {
                        StringBuffer buf = new StringBuffer();
                        buf.append(this.queryChars).append("\nQuery Results:").append("\n\tlr=").append(this.lastRecord);
                        int nItems = this.wobs == null ? 0 : this.wobs.length;
                        buf.append("\n\t").append(nItems).append(" ").append(nItems > 0 ? this.wobs[0].getClass().getName() : "").append("items");
                        for (int i = 0; i < nItems; ++i) {
                            buf.append("\n\t").append(this.wobs[i].getWorkObjectNumber());
                        }
                        this.m_desc = buf.toString();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (this.m_desc != null) {
                    return this.m_desc;
                }
            }
            return super.toString();
        }
    }

    public static class Filter
    implements Serializable {
        private static final long serialVersionUID = 7424L;
        private VWWorkBasketFilterDefinition filter = null;
        private String m_desc = null;

        public int getOperator() throws VWException {
            return this.filter.getOperator();
        }

        protected Filter(VWWorkBasketFilterDefinition filter, VWSession session) {
            this.filter = filter;
            this.filter.setSession(session);
        }

        public String getName() throws VWException {
            return this.filter.getName();
        }

        public String getAuthoredName() throws VWException {
            return this.filter.getAuthoredName();
        }

        public String getSearchFieldName() throws VWException {
            if (this.filter.getSearchField() == null) {
                return this.filter.getRuntimeSearchFieldName();
            }
            return this.filter.getSearchField().getAuthoredName();
        }

        public String getPrompt() throws VWException {
            return this.filter.getPrompt();
        }

        public String getDescription() throws VWException {
            return this.filter.getDescription();
        }

        public int getType() throws VWException {
            return this.filter.getType();
        }

        public VWAttributeInfo getAttributeInfo() throws VWException {
            return this.filter.getAttributeInfo();
        }

        public String toString() {
            if (this.m_desc == null) {
                if (logger.isFinest()) {
                    StringBuffer buf = new StringBuffer("VWWorkBasket.Filter=");
                    try {
                        buf.append(this.getName()).append(", t=").append(this.getType()).append(", p=").append(this.getPrompt()).append(", d=").append(this.getDescription());
                    }
                    catch (Exception e) {
                        buf.append("Got exception ").append(e);
                    }
                    this.m_desc = buf.toString();
                } else {
                    try {
                        this.m_desc = "VWWorkBasket.Filter:" + this.getName();
                    }
                    catch (Exception e) {
                        this.m_desc = "VWWorkBasket.Filter";
                    }
                }
            }
            return this.m_desc;
        }
    }

    public static class Column
    implements Serializable {
        private static final long serialVersionUID = 7424L;
        private VWWorkBasketColumnDefinition columnDef = null;
        private String m_desc = null;

        public String getName() throws VWException {
            return this.columnDef.getName();
        }

        public String getAuthoredName() throws VWException {
            return this.columnDef.getAuthoredName();
        }

        public int getType() throws VWException {
            return this.columnDef.getType();
        }

        public boolean isSortable() throws VWException {
            return this.columnDef.isSortable();
        }

        public String getPrompt() throws VWException {
            return this.columnDef.getPrompt();
        }

        protected Column(VWWorkBasketColumnDefinition columnDef, VWSession session) {
            this.columnDef = columnDef;
            this.columnDef.setSession(session);
        }

        public String toString() {
            if (this.m_desc == null) {
                if (logger.isFinest()) {
                    StringBuffer buf = new StringBuffer();
                    buf.append("VWWorkBasket.Column=");
                    try {
                        buf.append(this.getName()).append(", t=").append(this.getType()).append(", p=").append(this.getPrompt());
                    }
                    catch (Exception e) {
                        buf.append("Got exception!").append(e);
                    }
                    this.m_desc = buf.toString();
                } else {
                    try {
                        this.m_desc = "VWWorBasket.Column:" + this.getName();
                    }
                    catch (Exception e) {
                        this.m_desc = "VWWorkBasket.Column";
                    }
                }
            }
            return this.m_desc;
        }

        public VWAttributeInfo getAttributeInfo() throws VWException {
            return this.columnDef.getAttributeInfo();
        }
    }
}

